<?php
/* This file has been auto-generated. Do not edit this file directly. */

abstract class Sabai_Addon_PaidListings_Model_Base_Order extends SabaiFramework_Model_Entity
{
    public function __construct(SabaiFramework_Model $model)
    {
        parent::__construct('Order', $model);
        $this->_vars = array('order_entity_id' => 0, 'order_status' => 0, 'order_price' => 0, 'order_transaction_id' => null, 'order_currency' => null, 'order_gateway' => null, 'order_gateway_data' => null, 'order_payment_type' => null, 'order_id' => 0, 'order_created' => 0, 'order_updated' => 0, 'order_plan_id' => 0, 'order_user_id' => 0);
    }

    public function __clone()
    {
        $this->_vars = array('order_id' => 0, 'order_created' => 0, 'order_updated' => 0) + $this->_vars;
    }

    public function __toString()
    {
        return 'Order:' . $this->__get('id');
    }

    protected function _assignUser($user, $markDirty = true)
    {
        $this->_setVar('order_user_id', $user->id, $markDirty);
    }

    protected function _fetchUser()
    {
        if (!isset($this->_objects['User'])) {
            $this->_objects['User'] = $this->_model->UserIdentity($this->_vars['order_user_id']);
        }

        return $this->_objects['User'];
    }

    public function isOwnedBy($user)
    {
        return $this->user_id && $this->user_id == $user->id;
    }

    public function addOrderItem(Sabai_Addon_PaidListings_Model_OrderItem $entity)
    {
        $entity->Order = $this;

        return $this;
    }

    public function removeOrderItem(Sabai_Addon_PaidListings_Model_OrderItem $entity)
    {
        $this->removeOrderItemById($entity->id);

        return $this;
    }

    public function removeOrderItemById($id)
    {
        $this->_removeEntityById('orderitem_id', 'OrderItem', $id);

        return $this;
    }

    public function createOrderItem()
    {
        return $this->_createEntity('OrderItem');
    }

    public function removeOrderItems()
    {
        $this->_removeEntities('OrderItem');

        return $this;
    }

    public function addOrderLog(Sabai_Addon_PaidListings_Model_OrderLog $entity)
    {
        $entity->Order = $this;

        return $this;
    }

    public function removeOrderLog(Sabai_Addon_PaidListings_Model_OrderLog $entity)
    {
        $this->removeOrderLogById($entity->id);

        return $this;
    }

    public function removeOrderLogById($id)
    {
        $this->_removeEntityById('orderlog_id', 'OrderLog', $id);

        return $this;
    }

    public function createOrderLog()
    {
        return $this->_createEntity('OrderLog');
    }

    public function removeOrderLogs()
    {
        $this->_removeEntities('OrderLog');

        return $this;
    }

    public function __get($name)
    {
        if ($name === 'entity_id')
            return $this->_vars['order_entity_id'];
        elseif ($name === 'status')
            return $this->_vars['order_status'];
        elseif ($name === 'price')
            return $this->_vars['order_price'];
        elseif ($name === 'transaction_id')
            return $this->_vars['order_transaction_id'];
        elseif ($name === 'currency')
            return $this->_vars['order_currency'];
        elseif ($name === 'gateway')
            return $this->_vars['order_gateway'];
        elseif ($name === 'gateway_data')
            return $this->_vars['order_gateway_data'];
        elseif ($name === 'payment_type')
            return $this->_vars['order_payment_type'];
        elseif ($name === 'id')
            return $this->_vars['order_id'];
        elseif ($name === 'created')
            return $this->_vars['order_created'];
        elseif ($name === 'updated')
            return $this->_vars['order_updated'];
        elseif ($name === 'plan_id')
            return $this->_vars['order_plan_id'];
        elseif ($name === 'user_id')
            return $this->_vars['order_user_id'];
        elseif ($name === 'Plan')
            return $this->_fetchEntity('Plan', 'plan_id');
        elseif ($name === 'OrderItems')
            return $this->_fetchEntities('OrderItem', 'OrderItems');
        elseif ($name === 'OrderLogs')
            return $this->_fetchEntities('OrderLog', 'OrderLogs');
        elseif ($name === 'User')
            return $this->_fetchUser();
        else
            return $this->fetchObject($name);
    }

    public function __set($name, $value)
    {
        if ($name === 'entity_id')
            $this->_setVar('order_entity_id', $value);
        elseif ($name === 'status')
            $this->_setVar('order_status', $value);
        elseif ($name === 'price')
            $this->_setVar('order_price', $value);
        elseif ($name === 'transaction_id')
            $this->_setVar('order_transaction_id', $value);
        elseif ($name === 'currency')
            $this->_setVar('order_currency', $value);
        elseif ($name === 'gateway')
            $this->_setVar('order_gateway', $value);
        elseif ($name === 'gateway_data')
            $this->_setVar('order_gateway_data', $value);
        elseif ($name === 'payment_type')
            $this->_setVar('order_payment_type', $value);
        elseif ($name === 'id')
            $this->_setVar('order_id', $value);
        elseif ($name === 'user_id')
            $this->_setVar('order_user_id', $value);
        elseif ($name === 'User')
            $this->_assignUser($value);
        elseif ($name === 'plan_id')
            $this->_assignEntityById('Plan', $value, 'order_plan_id');
        elseif ($name === 'Plan') {
            $_value = is_array($value) ? $value[0] : $value;
            if (is_object($_value)) {
                $this->_assignEntity($_value, 'order_plan_id');
            } else {
                $this->_assignEntityById('Plan', $_value, 'order_plan_id');
            }
        }
        elseif ($name === 'OrderItems') {
            $this->removeOrderItems();
            foreach (array_keys($value) as $i) $this->addOrderItem($value[$i]);
        }
        elseif ($name === 'OrderLogs') {
            $this->removeOrderLogs();
            foreach (array_keys($value) as $i) $this->addOrderLog($value[$i]);
        }
        else
            $this->assignObject($name, $value);
    }

    protected function _initVar($name, $value)
    {
        if ($name === 'order_entity_id')
            $this->_vars['order_entity_id'] = (int)$value;
        elseif ($name === 'order_status')
            $this->_vars['order_status'] = (int)$value;
        elseif ($name === 'order_price')
            $this->_vars['order_price'] = (float)$value;
        elseif ($name === 'order_gateway_data')
            $this->_vars['order_gateway_data'] = @unserialize($value);
        elseif ($name === 'order_id')
            $this->_vars['order_id'] = (int)$value;
        elseif ($name === 'order_created')
            $this->_vars['order_created'] = (int)$value;
        elseif ($name === 'order_updated')
            $this->_vars['order_updated'] = (int)$value;
        elseif ($name === 'order_plan_id')
            $this->_vars['order_plan_id'] = (int)$value;
        elseif ($name === 'order_user_id')
            $this->_vars['order_user_id'] = (int)$value;
        else
            $this->_vars[$name] = $value;
    }
}

abstract class Sabai_Addon_PaidListings_Model_Base_OrderRepository extends SabaiFramework_Model_EntityRepository
{
    public function __construct(SabaiFramework_Model $model)
    {
        parent::__construct('Order', $model);
    }

    public function fetchByUser($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('order_user_id', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByUser($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('User', $id, $perpage, $sort, $order);
    }

    public function countByUser($id)
    {
        return $this->_countByForeign('order_user_id', $id);
    }

    public function fetchByUserAndCriteria($id, SabaiFramework_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('order_user_id', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByUserAndCriteria($id, SabaiFramework_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('User', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByUserAndCriteria($id, SabaiFramework_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('order_user_id', $id, $criteria);
    }

    public function fetchByPlan($id, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeign('order_plan_id', $id, $limit, $offset, $sort, $order);
    }

    public function paginateByPlan($id, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntity('Plan', $id, $perpage, $sort, $order);
    }

    public function countByPlan($id)
    {
        return $this->_countByForeign('order_plan_id', $id);
    }

    public function fetchByPlanAndCriteria($id, SabaiFramework_Criteria $criteria, $limit = 0, $offset = 0, $sort = null, $order = null)
    {
        return $this->_fetchByForeignAndCriteria('order_plan_id', $id, $criteria, $limit, $offset, $sort, $order);
    }

    public function paginateByPlanAndCriteria($id, SabaiFramework_Criteria $criteria, $perpage = 10, $sort = null, $order = null)
    {
        return $this->_paginateByEntityAndCriteria('Plan', $id, $criteria, $perpage, $sort, $order);
    }

    public function countByPlanAndCriteria($id, SabaiFramework_Criteria $criteria)
    {
        return $this->_countByForeignAndCriteria('order_plan_id', $id, $criteria);
    }

    protected function _getCollectionByRowset(SabaiFramework_DB_Rowset $rs)
    {
        return new Sabai_Addon_PaidListings_Model_Base_OrdersByRowset($rs, $this->_model->create('Order'), $this->_model);
    }

    public function createCollection(array $entities = array())
    {
        return new Sabai_Addon_PaidListings_Model_Base_Orders($this->_model, $entities);
    }
}

class Sabai_Addon_PaidListings_Model_Base_OrdersByRowset extends SabaiFramework_Model_EntityCollection_Rowset
{
    public function __construct(SabaiFramework_DB_Rowset $rs, Sabai_Addon_PaidListings_Model_Order $emptyEntity, SabaiFramework_Model $model)
    {
        parent::__construct('Orders', $rs, $emptyEntity, $model);
    }

    protected function _loadRow(SabaiFramework_Model_Entity $entity, array $row)
    {
        $entity->initVars($row);
    }
}

class Sabai_Addon_PaidListings_Model_Base_Orders extends SabaiFramework_Model_EntityCollection_Array
{
    public function __construct(SabaiFramework_Model $model, array $entities = array())
    {
        parent::__construct($model, 'Orders', $entities);
    }
}